/*
// Persistence of Vision Ray Tracer Scene Description File
// File: tmlab.pov
// Vers: 3.1g.wmp.0.6a
// Desc: irtc laboratory entry
// Date: 25/10/00
// Auth: Tom Melly, http://www.tomandlu.co.uk, tom@tomandlu.co.uk
//
*/

/***** init and macros ******/
#version unofficial MegaPov 0.6;

#declare do_mayo      = 1;
#declare blob_freq    = 0.2; // should be 0.1-0.2 (bread holes)
#declare wip_only     = 0; // 0 to render established objects

global_settings{
  max_trace_level 15
}
 
#include "colors.inc"
#include "textures.inc"
#include "woods.inc"
#include "metals.inc"
#include "glass.inc"

#macro Reorient(Axis1,Axis2)
  #local vX1=vnormalize(Axis1);
  #local vX2=vnormalize(Axis2);
  #local vY=vnormalize(vcross(vX1,vX2));
  #if (vlength(vY)>0)
    #local vZ1=vnormalize(vcross(vX1,vY));
    #local vZ2=vnormalize(vcross(vX2,vY));
    matrix < vX1.x, vY.x,vZ1.x, vX1.y,vY.y,vZ1.y, vX1.z,vY.z, vZ1.z, 0,0,0 >
    matrix < vX2.x,vX2.y,vX2.z,  vY.x,vY.y, vY.z, vZ2.x,vZ2.y,vZ2.z, 0,0,0 >
  #end
#end

#macro mayo_blobs_macro()
  #declare low_x = 0;
  #declare low_z = 0;
  #declare high_x = 0;
  #declare high_z = 0;
  
  #declare R_Val = 0.1;
  #declare S_Val = 0.5;
  #declare x1_count = -5;
  #while (x1_count < 6)
    #declare z1_count = -6;
    #while (z1_count < 5)
      #if ( (rand(Rand1) < 0.4)  & ((x1_count < -3 | x1_count > 4) | (z1_count < -4 | z1_count > 3)) )
        #declare x2_count = x1_count;
        #while (x2_count < (x1_count+1/2))
          #declare z2_count = z1_count;
          #while (z2_count < (z1_count+1/2))
            #declare norm_reg = <0,0,0>;
            #declare trace_result =
              trace(lower_bread, <x2_count, 5, z2_count>, <x2_count/2, -5, z2_count/2>, norm_reg);
            #if (norm_reg.x != 0 | norm_reg.y != 0 | norm_reg.z != 0)
              #if (low_x > x2_count) #declare low_x = x2_count; #end #if (high_x < x2_count) #declare high_x = x2_count; #end
              #if (low_z > z2_count) #declare low_z = z2_count; #end #if (high_z < z2_count) #declare high_z = z2_count; #end
              sphere {
                <0,0,0>, R_Val, S_Val 
                scale <1+(rand(Rand1)/1), 0.5+(rand(Rand1)/2), 1+(rand(Rand1)/1)>
                Reorient(y, norm_reg)
                translate trace_result
              }          
            #end 
            #declare z2_count = z2_count + ((rand(Rand1) - 0.5)*0.1)+speedAdd2*rand(Rand1);
          #end
          #declare x2_count = x2_count + ((rand(Rand1) - 0.5)*0.1)+speedAdd2*rand(Rand1);
        #end
      #end
      #declare z1_count = z1_count + (rand(Rand1) - 0.5)*0.5 + (speedAdd1*rand(Rand1));
    #end
    #declare x1_count = x1_count + (rand(Rand1) - 0.5)*0.4 + (speedAdd1*rand(Rand1));
  #end
  #debug concat("high x ", str(high_x, 2,2), "\n") #debug concat("low x ", str(low_x, 2,2), "\n")
  #debug concat("high z ", str(high_z, 2,2), "\n") #debug concat("low z ", str(low_z, 2,2), "\n")
#end

/***** lights, camera *****/
camera{
  location <0.0, 45.0, -50.0>
  look_at <1.0, 10.0,  0.0>
}

light_source{
  <0,0,0> 
  color rgb<1,1,0.96>*0.75 // was 0.75
  translate <-50, 80, -75>
  fade_distance 180
  fade_power 2
}

light_source{<0,0,0> color rgb<1,1,0.96>*0.5 translate <0, 45, -50> shadowless}

/***** sandwich ******/
#declare bread_slice_no_holes =
intersection{
  box{<0,0,0>,<10,1,10>}
  blob{
    threshold 0.25
    sphere{0,4,1 scale<1.0,1.0,0.5> rotate y*-15 translate<3,0.5,8>}
    sphere{0,3,1 scale<1.0,1.0,0.5> rotate y*0 translate<7.5,0.5,8>}
    sphere{0,7.5,1 translate<5,0.5,3.25>}
  }
}

#declare bread_holes =
blob{
  threshold 0.5
  #declare Rand1 = seed(34532);
  #declare n = 0;
  #declare m = 0;
  #while (n <= 10)
    #while (m <= 10)
      sphere{<n+rand(Rand1)-0.5, 1+rand(Rand1), m+rand(Rand1)-0.5>, 0.25*rand(Rand1), 0.5+rand(Rand1)
        scale<1+rand(Rand1), 0.1+rand(Rand1), 1+rand(Rand1)>}
      #declare m = m+blob_freq;
    #end
    #declare m = 0;
    #declare n= n+blob_freq;
  #end
} // end of blob

#declare bread_slice=
difference{
  object{bread_slice_no_holes}
  object{bread_holes}
  pigment{rgb<1,1,0.95>*1.5}
  normal{average turbulence 1 normal_map{[bozo 1 scale 4][leopard 5 scale 0.1 turbulence 1]}} // not bad
  bounded_by{box{-0.01,<10.01,1.01,10.01>}}
  translate<-5,0,-5>
}

#declare bread_crust =
difference{
  blob{
    threshold 0.25
    #declare n = 0;
    #while(n<360)
      #declare pos_x = cos(radians(n));
      #declare pos_z = sin(radians(n));
      #declare trace_norm=<0,0,0>;
      #declare trace_pos=<(pos_x*15)+5, 0.5, (pos_z*15)+5>;
      #declare lookat_pos=<(-pos_x*15), 0, (-pos_z*15)>;
      #declare edge_pos = trace(bread_slice_no_holes, trace_pos, lookat_pos, trace_norm);  
      #if (trace_norm.x != 0 | trace_norm.y != 0 | trace_norm.z != 0) 
        sphere{
          0, (rand(Rand1)/8)+0.25, 1
          scale<rand(Rand1)+0.75,3,rand(Rand1)+0.75>
          translate edge_pos
        } 
      #end   
      #declare n = n + 1;
    #end
  }
  plane{y, -1}
  plane{-y, -1}
  pigment{wrinkles pigment_map{[0 Gold][1 Feldspar]}}
  normal{average normal_map{[wrinkles 2 scale 1][crackle 4 scale 1.25 turbulence 0.7]}}
  translate <-5,0,-5>
}  

#declare whole_bread =
union{
  object{bread_slice}
  object{bread_crust}
}

#declare isoLettuce =
isosurface{
  #declare f1 = function {"ridgedMF" <1,2,5,0.5,10>}
  #declare f2 = function{pigment{wrinkles}}
  function{abs(y) + f1(x*5, y*5, z*5)/5 + f2 - 1}
  max_gradient 3
  eval
  threshold 0
  sign 1
  accuracy .001
  contained_by{sphere{0,1}}
  open
  scale<1,1,1>
}

#declare LettuceLeaf =
difference{
  object{isoLettuce}
  plane{y, 0 pigment{rgbf 1}}
  pigment{wrinkles pigment_map{[0 Green][1 DarkGreen]}}
  finish{Glossy}
}

#declare lower_bread =
union{
  object{whole_bread}
  object{LettuceLeaf translate y*-0.5 scale <8,6,7> translate <0.5,1.55,-0.6>}
  box{<-4.5,1.8,-6>,<5,2.04,5> pigment{bozo scale 0.5 pigment_map{[0.6 Yellow*0.75][0.6 rgbf 1]}} rotate y*-15}
  cylinder{y*2.05, y*2.3, 6
    pigment{
      cylindrical scale 6 pigment_map{
        [0.05 granite scale 1/10 pigment_map{[0 Brown][0.5 DarkBrown][1 DarkGreen]}]
        [0.05 agate scale 1/6 turbulence 0.5 pigment_map{[0.25 White][0.30 Pink]}]
      }
    }
  }
}

#declare speedAdd1 = 0.7; // was 0.8
#declare speedAdd2 = 0.1;
#if (do_mayo = 1)
  #declare mayo_blobs = blob{threshold 0.5 mayo_blobs_macro() texture{pigment{Goldenrod} finish{Glossy}}}
#end

#declare sandwich =
union{
  object{lower_bread}
  object{whole_bread rotate y*10 translate y*2.31}
  #if (do_mayo = 1) object{mayo_blobs finish{Glossy}} #end
  scale<1,1,1>
  translate z*-0.3
}

/***** specimen cups ******/
#declare cup_pigment = White; // was *1.25
#declare cup_texture = 
texture{
  pigment{cup_pigment}
  finish{
    reflection_type 1 reflection_max 0.5 reflection_min 0.1 reflection_blur 0.05 reflection_samples 20
    specular 0.95
    roughness 0.01
  }
  normal{wrinkles 0.03 scale 0.25 turbulence 0.5}
}

// cup
#declare cup =
lathe {
  linear_spline
  7,
  <0,0>, <3.00,0.00>, <3.45,6.75>, <3.75,7.25>, <3.80,7.25>, <3.90,8.00>, <4.30,8.00>
  texture{cup_texture}
}

// top
#declare top =
lathe {
  linear_spline
  7,
  <0,0>, <3.50,0.00>, <3.70,0.75>, <3.75,0.85>, <4.30,0.85>, <4.35,0.00>, <4.45,-0.10>
  texture{cup_texture}
}

#macro make_text()
  #declare print_string = "POV-RAY MEDICAL. TEL 0353 666195."
  #declare print_len = strlen(print_string);
  #declare n = 0;
  #declare arc_ang = 150;
  #declare top_text =
  union{
    text {ttf "arialbd.ttf" label_string 1,0  align_center scale <0.9,0.7,0.9> rotate x*90
      translate <0,0.5,-0.25>}
    #while(n<print_len)
      #declare n = n + 1;
      #declare Letter = substr(print_string, n, 1)
      text{ttf "arialbd.ttf" Letter 1,0 scale <0.25,0.25,1> rotate x*90 translate <0,0.5,-3>
        rotate y*( (arc_ang/2) - (n*(arc_ang/print_len)) )}
    #end
  }
  #declare text_pig = pigment{object{top_text color cup_pigment color Black}}
#end

#declare cup_group1 =
union{
  #declare label_string = "SPUTUM"
  make_text()
  union{
    object{cup}
    object{top pigment{text_pig} translate y*7.2}
    translate<-5,0,-5>
  }
  #declare label_string = "URINE"
  make_text()
  union{
    object{cup}
    object{top pigment{text_pig} translate y*7.2}
    rotate y*-15
    translate<-11,0,3>
  }
  #declare label_string = "FAECES"
  make_text()
  union{
    object{cup}
    object{top pigment{text_pig} rotate z*-10 translate y*8}
    rotate y*+25
    translate<-3,0,8>
  }
  #declare label_string = "PUS"
  make_text()
  union{
    object{cup}
    object{top pigment{text_pig} translate y*7.2}
    rotate y*160
    translate x*3
    rotate z*80
    rotate y*-120
    translate<1,0,0>
  }
}

/***** teacup ******/
#declare tea_cup =
union{
  lathe{linear_spline 4, <0,0>,<5.00, 0.00>,<6.00,9.00>,<6.00, 12.00>}
  torus{6.00, 0.15 translate<0,9,0>}
  torus{6.00, 0.15 translate<0,12,0>}
  cone{0.1*y, 5, 9*y, 5.99 pigment{Gold*2}}
  pigment{White}
  normal{bozo 1 scale 0.2}
}

#declare tea_cup_lid =
difference{
  cylinder{0, 1*y, 6.35} // main disk
  difference{ // center punch with inner rise
    cylinder{0.25*y, 1.1*y, 5.25}
    difference{
      cylinder{0.20*y, 0.65*y, 2.50}
      cylinder{0.00*y, 0.40*y, 2.25}
    }
  }
  cylinder{-0.1*y, 1.2*y, 0.25} // inner hole
  difference{ // inset outer rim
    cylinder{-0.1*y, 0.85*y, 6.20}
    cylinder{-0.2*y, 1.00*y, 5.50}
  }
  pigment{White*1.5 filter 0.5}
}

#declare cup_and_lid =
union{
  object{tea_cup_lid translate y*11.25}
  object{tea_cup}
  scale<1,1.25,1>
}

/***** plate ******/
#declare plate =
lathe{
  linear_spline
  6,
  <0,0>,<6.75,0.00>, <7,0.10>, <9,0.75>, <9,0.65>,<7,0>
  pigment{White}
  normal{bozo 1 scale 0.2}
}

/***** tray *****/
#declare edge =
difference{
  box{<-1,-1,-1>, <1,3,1>}
  cylinder{<1,-2,1>, <1,4,1>,1}
}

#declare tray_outline =
difference{
  box{0, <10,2,17>}
  object{edge}
  object{edge rotate y*-90 translate x*10}
  object{edge rotate y*90 translate z*17}
  object{edge rotate y*180 translate x*10 translate z*17}
}

#declare tray =
difference{
  union{
    object{tray_outline}
    object{tray_outline scale<1.05,0.05,1.05> translate <-0.25,1.96,-0.25>}
  }
  object{tray_outline scale 0.95 translate <0.25,0.3, 0.25>}
  scale<1,2,1>
}

#declare tray_1 =
object{
  tray
  scale <3,1,2.5>
  texture{T_Chrome_3C}
  normal{
    average 
    normal_map{
      [wrinkles 0.1 scale 15]
      [dents 0.25 scale 2]
    }
  }
}

/***** room ******/
#declare table_texture =
texture{
  pigment{crackle turbulence 0.6 scale 2 pigment_map{[0.1 rgb<0.58,0.60,0.62>][0.2 rgb<0.3, 0.4, 0.5>]}}
  finish{Dull reflection_type 1 reflection_max 0.1 reflection_min 0.05}
}

#declare desk_wood_base=
texture{pigment{DMFWood3 scale 2}}

#declare desk =
union{
  difference{
    plane{ y, -0.1 texture{table_texture scale 3}}
    plane{z, -14 texture{desk_wood_base}}
  }
  cylinder{-50*x, 50*x, 2 translate<0, -2.1, -14> texture{table_texture scale 3}}
  box{<0,-10,-14.1>,<40,-35,-15.5> texture{desk_wood_base} translate x*5}
  box{<0,-10,-14.1>,<40,-35,-15.5> texture{desk_wood_base} translate x*-40}
}

#declare floor_tex =
texture{
  pigment{
    checker
    pigment{Black}, 
    pigment{
      agate scale 0.2 turbulence 0.5
      pigment_map{
        [0.2 Black][0.4 White]
      }
    }
    scale 10
  }
}

#declare room =
union{
  box{<-100,-80, -120>, <100,150, 120> inverse pigment{bozo scale 5 pigment_map{[0 White][1 Grey]}}}
  plane{y, -75 texture{floor_tex}}
}

#declare bracket =
intersection{
  union{
    cylinder{<-1,0,0>,<1,0,0>, 2}
    box{<-1,1.65,0>, <1,2,4>}
    box{<-1,1.65,0>, <1,2,4> translate -4*y}
    box{<-1,3.5,3>,<1,-3.5,6>}
  }
  box{<-0.9,-6,-2>,<0.9,6,3>}  
}

#declare Tom_T_Copper_2B = 
texture{
  pigment{P_Copper2}
  finish{F_MetalB}
  normal{dents 2 scale 0.25}
}

#declare pipe_tarnish =
texture{
  pigment{agate scale 1 turbulence 0.4 pigment_map{[0.2 rgbf 1][0.4 rgbf 0.9][0.6 rgbf<0.3,0.6,0.4,0.8>]}}
}

#declare pipe_paint =
texture{
  pigment{wrinkles scale 5 turbulence 0.5 pigment_map{[0.45 rgbf 1][0.45 White*0.8]}}
  normal{agate 0.5}
  finish{Glossy} // was shiny
}

#declare pipe =
union{
  cylinder{x*-200, x*200, 1.6}   

  #declare n = -200;
  #while(n < 200)
    object{bracket translate x*n}
    #declare n = n + 50;
  #end

  translate <0,5,61>
  texture{Tom_T_Copper_2B}
  texture{pipe_tarnish}
  texture{pipe_paint}
}

#declare wall_tex1 = // underlying bricks
texture{
  pigment{
    brick
    pigment{granite pigment_map{[0 Grey][1 DimGrey]}}
    pigment{wrinkles pigment_map{[0 Brown][0.5 DarkBrown][1 Firebrick * 0.7]}}
    scale 1
  }
  normal{
    brick
    normal{granite 2}
    normal{average normal_map{[wrinkles][granite 2]}}
    scale 1
  }
}

#declare wall_tex2 = // paint
texture{
  pigment{wrinkles scale 8 turbulence 0.5 pigment_map{[0.40 rgbf 1][0.40 White]}}
  normal{
    average normal_map{
      [brick normal{granite 1} normal{average normal_map{[wrinkles 0.55][granite 0.75]}} scale 1]
      [wrinkles scale 8 turbulence 0.5 normal_map{[0.40 wrinkles 0][0.40 agate 2 scale 0.1][0.45 wrinkles 0]}]
    }
  }
  finish{Glossy} // was shiny
}

#declare wall =
plane{-z, 0
  texture{wall_tex1}
  texture{wall_tex2}
  scale 3 translate <0,-1,65>
}

/***** petri dish *****/
#declare basic_petri =
cylinder{0,y*1.5,8}

#declare hollow_petri =
difference{
  object{basic_petri}
  object{basic_petri scale <0.95,1,0.95> translate y*0.15}
  texture{T_Glass3}
  interior{I_Glass}
}

#declare base_petri =
object{hollow_petri}

#declare top_petri =
object{hollow_petri rotate x*180 scale <1.08,0.75,1.08>}

#declare full_petri =
union{
  object{base_petri}
  object{top_petri translate y*1.75}
}

#declare petri_group1 =
union{
  object{full_petri translate <-20,0,50>}
  object{full_petri translate <-22,1.76*1,49>}
  object{full_petri translate <-19,1.76*2,48>}
  object{full_petri translate <-21,1.76*3,51>}
  object{full_petri translate <-18,1.76*4,49>}
  
  object{base_petri translate <-40,0,51>}
  object{top_petri rotate z*8 translate <-48,1.75,46>}
}

/****** bunsen burner *****/
#declare bunsen =
difference{
  union{
    difference{ // main shape
      sor{ // main shape, w/o hole
        6,
        <0.0, -0.5>,
        <4.5,  0.0>,
        <1.1,  1.5>,
        <1.0,  1.6>,
        <1.0, 12.0>,
        <1.0, 13.0>
      }
      sphere{0,0.7 translate<1.25,2.2+1,0> rotate y*160} // hole
    }
    cylinder{0,y*1.75,1.15 translate y*11} // top ring
    
    difference{ // ring
      cylinder{0, y*2, 1.25 translate y*2.2}
      sphere{0,0.7 translate<1.25,2.2+1,0> rotate y*140}
    }
    cylinder{0, <1.5,2,0>, 0.5 translate x*2} // nozzle
  }
  cylinder{0,y*15, 0.75} // hollow out tube
  texture{
    pigment{
      granite
      pigment_map{
        [0.0 Gray10]
        [0.5 Gray20]
        [1.0 Gray30]
      }
    }
    finish{Dull}
    normal{granite 0.25}
  }
}
  
#declare pipe_diam = 0.8;

#declare gas_pipe =
sphere_sweep{
  catmull_rom_spline_sphere_sweep
  10,

  <0.0, -1.0, 0.0>, pipe_diam,
  <3.5,  2.0, 0.0>, pipe_diam,
  <6.5,  3.0, 0.0>, pipe_diam,
  <10.0, 2.0, 0.0>, pipe_diam,
  <20.0, 1.0, -5.0>, pipe_diam,
  <26.0, pipe_diam+rand(Rand1*0.05)+0.05,  1>, pipe_diam,
  <30.0, pipe_diam+rand(Rand1*0.05)+0.05,  4>, pipe_diam,
  <35.0, pipe_diam+rand(Rand1*0.05)+0.05,  5>, pipe_diam,
  <45.0, pipe_diam+rand(Rand1*0.05)+0.05,  3>, pipe_diam
  <50.0, pipe_diam+rand(Rand1*0.05)+0.05,  0>, pipe_diam

  pigment{rgb<0.5,0.1,0.1>}
  finish{diffuse 0.9}
}
#declare bunsen_flame =
intersection{
  box{<-1.6,0,-1.6>,<1.6,1.6,1.6>}
  sphere{0,1.5
    interior{
      media{
        method 3
        emission rgb 1
        absorption rgb 1
        density{
          spherical 
          scale <1,2,1>
          turbulence 0.5
          density_map{
            [0.0 Black]
            [0.5 Blue*0.5]
            [0.8 White*1.5]
          }
        }
      }
    }
  }
  scale <1,7,1>
  pigment{rgbf 1}
  hollow on
  no_shadow
  translate y*15
  scale 1/1.25
}

#declare bunsen_flame_shadow =
intersection{
  box{<-1.6,0,-1.6>,<1.6,1.6,1.6>}
  sphere{0,1.5}
  pigment{
    slope <-2,0,1>
    pigment_map{
      [0.1 rgbf 1]
      [0.3 agate scale<1,1/12,1> scale 0.5 pigment_map{[0 rgbf 1.05][1 Gray90 filter 1]}]
      [0.7 agate scale<1,1/12,1> scale 0.5 pigment_map{[0 rgbf 1.05][1 Gray90 filter 1]}]
      [0.9 rgbf 1]
    }
  }
  scale <1,12,1>
  hollow on
  no_reflection
  no_image
  translate y*15
  scale 1/1.25
}

#declare bunsen_burner =
union{
  object{bunsen translate y*0.01}
  object{gas_pipe}
  object{bunsen_flame}
  object{bunsen_flame_shadow}
  scale 1.25
  rotate y*-25
  translate x*16
  translate z*-5
}


/***** socket *****/
#declare socket_shape =
superellipsoid {
  <.25, .25>
  scale 10
  scale<3.5,1.2,1>
}

#declare socket_base_and_lid =
union{
  object{socket_shape}
  object{socket_shape scale<1.03,1.03,0.2> translate z*-8}
//  translate x*12
}

#declare hole =
box{
  <0.1,0.1,-1>,<5.9,2.9,14>
  pigment{White}
  finish{Glossy}
  translate z*-10.2
}

#declare hole_filler =
difference{
  box{0,<6,3,12>}
  box{<1,0.4,-1>,<5,2.6,10>}
  pigment{White}
  finish{Glossy}
  translate z*-10.2
}

#declare socket =
union{
  difference{
    object{socket_base_and_lid}

    object{hole translate<-24,-7,0>}
    object{hole translate<-12,-7,0>}

    object{hole translate<12,-7,0>}
    object{hole translate<24,-7,0>}

    object{hole rotate z*90 translate<-14,1,0>}
    object{hole rotate z*90 translate<22,1,0>}
  }

  object{hole_filler translate<-24,-7,0>}
  object{hole_filler translate<-12,-7,0>}

  object{hole_filler translate<12,-7,0>}
  object{hole_filler translate<24,-7,0>}

  object{hole_filler rotate z*90 translate<-14,1,0>}
  object{hole_filler rotate z*90 translate<22,1,0>}

  difference{ // screw head
    sphere{0, 1.6 scale<1,1,0.1>}
    sphere{0, 1.6 scale<1,0.1,1> rotate z*35 translate z*-0.25}
    translate x*-32 translate z*-12
    texture{pigment{Gray40} finish{F_MetalC}}
  }
}

#declare full_socket =
object{
  socket
  texture{
    pigment{Gray50}
    finish{Metallic_Finish}
    normal{
      average
      normal_map{
        [granite 0.25 scale<10,1,10> rotate y*45 rotate z*45]
        [granite 0.15]
        [dents 2 scale 5]
      }
    }
  }
  texture{
    pigment{bozo scale 5 turbulence 0.25
      pigment_map{
        [0.5 rgbf 1]
        [1.00 rgbf <0.1,0.1,0.1,0.1>]
      }
    }
  }
  scale 0.5
  translate z*62
  translate y*20
  translate x*62
}

/***** scene *****/
#if (wip_only < 1)

  object{cup_and_lid translate<30,0,15>}
  object{sandwich scale 2 rotate y*105 translate<25,0,35>}
  object{plate scale 2 translate<25,0,35>}
  object{tray_1 rotate y*-20 translate<-22,0,-22>}
  object{cup_group1 translate<-10,0.65,-5.5>}
  object{full_socket}
  object{bunsen_burner}
  object{petri_group1}
  
  object{room}
  object{wall}
  object{wall rotate y*180 translate z*-30}
  object{pipe translate y*-1 translate x*-50}
  object{pipe translate y*3 translate x*50}
  object{desk}

#end

/***** wip ******/

