// --------------------------------------
// Grass texture
// --------------------------------------
#version unofficial MegaPov 0.4;  

#declare Green1=rgb<230,170,50>/255;
#declare Green2=rgb<110,160,8>/255;
#declare Green1=rgb<0.4,1,0.3>*0.4;
#declare Green2=rgb<60,160,8>/255;

#declare pigSpotted =
pigment{
  spotted
    color_map {
        [0.0, 0.2   color Tan*0.1 color Tan*0.4]
        [0.2, 0.3   color Tan*0.4 color Green1*0.5]
        [0.3, 1.01   color Green1 color Green1*0.75]
    }
}

#declare pigEarth =
pigment{
  spotted
  color_map {
    [0 color Tan*0.3]
    [0.6 color Tan*0.3]
    [0.6 color Green1*0.3]
    [1   color Green1*0.3]
  }
}

#declare pigGreen=pigment{Green2*1.3}

#declare GrassTexture =
texture {                  
  pigment {
    gradient y
    turbulence 0.2
    pigment_map {                                
      [0.0 pigSpotted]//was earth
      [0.3 pigGreen]
      [0.9 pigSpotted]
      [1.00 pigEarth]
    }
  }
  finish{ambient 0.01 diffuse 0.7 specular 0.2 roughness 0.015}
  scale <0.1,1,0.1> //was 001
}

#declare GrassTexture2=
texture{
  pigment{Green}
}


#declare CliffTexture =
texture{
  pigment{rgb<0.8,0.8,0.8>}
  normal {granite 0.75 rotate z*90 scale 0.1 turbulence 0.75}
}

#declare WholeCliffTexture =
texture{
  slope y, y
  turbulence 0.25
  texture_map{
    [0.00 CliffTexture]
    [0.70 CliffTexture]
    [0.70 pigment{pigEarth}]
    [0.75 GrassTexture scale 1/1000]
    [1.00 GrassTexture scale 1/1000]
  }
}

#declare CastleTexture =
texture{
  pigment{
    agate turbulence 0.25 scale 0.25
    pigment_map{
      [0.0 rgb<0.2,0.2,0.2>]
      [0.5 rgb<0.5, 0.5, 0.5>]
      [0.9 rgb<0.5, 0.5, 0.5>]
      [1.0 rgb<0.25, 0.5, 0.25>]
    }
  }
  normal{
    average
    normal_map{
      [dents 1]
      [brick 5 scale 1]
    }
  }
}

#declare Watermaterial = material{     
  texture {
    pigment{rgb<0.3,0.4,0.7> filter 0.85}
    normal{
      ripples 0.5
      frequency 2
      turbulence 0.3
      translate x*20
      scale 10
    }
    finish {
      specular 1
      roughness 0.001
      ambient 0
      diffuse 0
      reflection 0.45
    }
  }
  interior { ior 1.2 caustics 1.0 }
}

#macro FootSteps (StartPos, EndPos, PaceDistance) // y is irrelevant for vectors
  #local XDistance = EndPos.x - StartPos.x;
  #local ZDistance = EndPos.z - StartPos.z;
  #local XZDistance = sqrt((XDistance * XDistance) + (ZDistance * ZDistance));
  #local TotalSteps = XZDistance / PaceDistance;
  #local XPos = StartPos.x;
  #local ZPos = StartPos.z;
  #local LoopCount = 0;
  #local LorR = 1;
  #while (LoopCount <= TotalSteps)
    #declare LorR = LorR*-1;
    #declare YPlane = trace(mybeach, <XPos, 100, ZPos>, <0, -100, 0>);
    height_field
    {
      gif               // the file type to read (gif/tga/pot/pgm/ppm/png/sys)
      "lfoot.gif"     // the file name to read
      scale <12,3,12*LorR>
      rotate <180, 50, 0>
      translate <XPos, YPlane.y+0.75, ZPos>
      pigment{Yellow}
    }

    #declare XPos = XPos + (XDistance / TotalSteps);
    #declare ZPos = ZPos + (ZDistance / TotalSteps);
    #declare LoopCount = LoopCount +1;
  #end
#end

#declare castlekeep =
difference{
  prism {
    conic_sweep
    linear_spline
    0.85, // height 1
    1, // height 2
    5, // the number of points making up the shape...
    <3,3>,<-3,3>,<-3,-3>,<3,-3>,<3,3>
    rotate x*180
    translate y*1
    scale <1,45,1>
  }
  box{<1.75, 5.5, 1.75>,<-1.75, 10, -1.75>}
  box{<1,6,3>,<0.5, 10, -3>}
  box{<-1,6,3>,<-0.5, 10, -3>}
  box{<3,6,-1>,<-3, 10, -0.5>}
  box{<3,6,1>,<-3, 10, 0.5>}
}
 
#declare castleturret =
difference{
  difference{
    cone{<0,0,0>, 1.75, <0,10,0>, 1.25}
    box{<-2,8,-0.35>, <2,11,0.35>}
    box{<-0.35,8,-2>, <0.35,11,2>}
    cylinder{<0,8,0>,  <0,11,0>,  0.75}
  }
  box{<-5,8.75,-5>, <5,11,5>}
}

#declare castlewhole =
union{
  object{castlekeep}
  object{castleturret translate <3,0,3>}
  object{castleturret translate <3,0,3> rotate y*-90}
  object{castleturret translate <3,0,3> rotate y*-180}
  object{castleturret translate <3,0,3> rotate y*90}
}
