// Persistence of Vision Ray Tracer Scene Description File
// File: ruin1.pov
// Vers: 3.1g.wmp.0.3
// Desc: Basic Scene Example
// Date: 15/02/00
// Auth: Tom Melly tom@tomandlu.f9.co.uk
//
#version unofficial MegaPov 0.4;  

#include "colors.inc"
#include "skies.inc"
#include "ruin1.inc"

#declare Yellow = pigment{rgb<0.8,0.8,0.4>}

#declare dobeach = true;
#declare dosandcastle = true;
#declare docliff = true;
#declare docastle = true;
#declare dowater = true;
#declare whichview = 1;

global_settings { ambient_light White*1.5 }

#if (whichview = 1)
camera
{
  location  <0, 0, 0>
  look_at   <0, -15,  300>
}
#end

light_source
{
  0*x
  color White*2.0
  translate <2000, 1500, -10>
}



sky_sphere{ //sky
  S_Cloud1
}

#if (dobeach)
#declare mybeach =
height_field{ //near beach
	tga
	"beach.tga"
	smooth
	pigment{Yellow}
	scale <600, 10, 800>
}

difference{
  object {mybeach}
  FootSteps (<380,0.5,200>, <450,0.5,100>, 15)  //<-45,-16, 65>
	translate <-425,-15,-100>
}

object{ //midbeach
  mybeach
	translate <-425,-15,700>
}

object{ //farbeach
  mybeach
	translate <-425,-15,1500>
}

height_field{ //big beach
	tga
	"bigbeach.tga"
	smooth
	pigment {Yellow}
	scale <1400, 75, 2300>
	rotate z*-1
	translate <-1450, -8, -100>
}
#end

#if (dosandcastle)
#declare sandcastle =
difference{
  union{
    height_field{ //sandcastle mound
    	tga
    	"mound.tga"
    	smooth
    	pigment {Yellow}
      scale <30, 15, 30>
    }
    
    object{
      castlewhole
      scale <0.75,0.70,0.75>
      translate <15, 14.75, 15> 
      pigment{Yellow}
    }
  }

  height_field{
    tga
    "dent1.tga"
    scale <4, 22, 40>
    rotate <180,-45,0>
    translate <1, 30, 25>
    pigment{Yellow}
  }
}

object{
  sandcastle
  translate <-45,-16, 65>
  scale <2,1.5,1.5>
}
#end

#if (docliff)
#declare cliff =
height_field{
	tga
	"cliff.tga"
	smooth
  texture{WholeCliffTexture}
}

object{
  cliff
  scale <2000, 600, 1600>
	translate <-1600,-50,1000>
}
#end

#if (docastle)
difference{
  object{
    castlewhole
    scale <20,17,20>
  	translate <-300,550,1950>
  	texture{CastleTexture}
  }

  height_field{
    tga
    "dent1.tga"
    scale <85, 220, 400>
    rotate <180,-15,0>
    translate <-425, 800, 2100>
  	texture{CastleTexture}
  }
}
#end

#if (dowater)
plane{ // water
  y,
  -12.5 
  material {Watermaterial}
  hollow on
}
plane{ // ocean bed
  y,
  -5000
  pigment{Yellow}
}
#end



