// Persistence of Vision Ray Tracer Scene Description File
// File: tmruin.pov
// Vers: 3.1g.wmp.0.3
// Desc: Basic Scene Example
// Date: 18/02/00
// Auth: Tom Melly tom@tomandlu.f9.co.uk[esp]
//

#version unofficial MegaPov 0.4;

#declare doPicture = true;
#declare doSticky = true;

#include "colors.inc"
#include "skies.inc"

light_source{<0,0,0> color White*1.25 translate <-500, 350, -1000>}
camera{location  <0.0, 0.0, -600.0> look_at   <0.0, 0.0, 0.0>}

sky_sphere{ //sky
  S_Cloud1
}


// ----------------------------------------


#declare Picture =
polygon{
  5 <0,0>,<1,0>,<1,1>,<0,1>,<0,0>
  pigment{
    image_map{
      sys "ruin1.bmp"
      map_type 0
      interpolate 0
      once
    }
  }
  translate <-.5,-.5,1>
  scale <800,600,1>
}


#declare PaperTex =
texture{
  pigment{
    gradient y
    color_map{
      [0.1 LightBlue]
      [0.1 White*0.95]
      }
    scale 0.12
    translate y*0.04
  }
}

#declare StainColor = Sienna;

#declare StainMap =
pigment{
  bozo
  turbulence 0.25
  color_map{
    [0.5 StainColor filter 0.8]
    [1.0 White filter 1]
  }
  scale 0.05
}

#declare StainTex =
texture{
  pigment{
    cylindrical
    turbulence 0.25
    pigment_map{
      [0.00 White filter 1]
      [0.35 StainMap]
      [0.40 StainColor filter 0.0]
      [0.41 StainColor filter 0.3]
      [0.45 StainColor filter 0.4]
      [0.60 StainMap]
      [0.80 White filter 1]
      }
    scale 0.35
    rotate x*-90
    translate <0.2,0.1,0>
  }
}

#declare NoteTex =
texture{
  pigment{
    image_map{
      gif "notes.gif"
      map_type 0 // 0=planar, 1=spherical, 2=cylindrical, 5=torus
      interpolate 0 // 0=none, 1=linear, 2=bilinear, 4=normalized distance
      once
      transmit 255 1
    }
  }
}

#declare Sticky =
height_field{
  tga
  "sticky.tga"
  smooth
  rotate x*-90
  texture{PaperTex}
  texture{NoteTex}
  texture{StainTex}
}

#declare PinTex =
texture{
  pigment{rgb<0.7,0,0>}
  finish{
    phong 0.6 phong_size 40
    reflection 0.25
  }
}

#declare Pin =
sphere{
  <0,0,0>, 9
  scale <1,1,0.1>
  texture{PinTex}
}

#if (doPicture)
  object{Picture finish{ambient 0.3}}
#end

#if (doSticky)
  object{
    Sticky
    scale <150,145,75>
    rotate z*15
    translate <170,20,0>
    finish{ambient 0.4}
  }
  object{
    Pin
    rotate y*18 rotate x*-1
    translate<250,175,-22>
  }
#end


 
