#version unofficial MegaPov 0.5;

#declare Cloud_form = 
function{
  pigment {
    blob {
      sphere { <0,0,0>, 10, 1 density_function 0, 1 }
      sphere { <2,6,0>, 5, 1 density_function 0, 1 }
      sphere { <0,0,0>, 8, 1 density_function 0, 1 scale <1,0.7,1> translate<6,1,1>}
      sphere { <0,0,0>, 6, 1 density_function 0, 1 scale <1,0.6,1> translate<10,4,-2> }
      sphere { <0,0,0>, 13, 1 density_function 0, 1 scale <1,0.5,0.6> translate<-10,3,4> }
      sphere { <0,0,0>, 7, 1 density_function 0, 1 scale <1,0.5,0.6> translate<10,0,1> }
      sphere { <0,0,0>, 5, 1 density_function 0, 1 scale <1.25,0.5,1> translate<-5,0,-2> }
      threshold 0.075 // varying this produces some interesting variations .05 to .2
      max_density 1// leave
    }
    color_map {[0 rgb 0][1 rgb 1]}// seems to break up cloud lower more broken up higher more solid(no higher than 1.1)
  }
}

#declare Cloud_turb =
function{
  pigment {   // Play with this to get best cloud quality
    granite // warp{turbulence .25 omega .7 lambda .3}
    color_map {[0.0 rgb 0.0][0.4 rgb 0.8][1.0 rgb 0.5]}
    scale 15 // size of turbulence 10 to 25
  } 
}

#declare Cloud1 = function { max(0,Cloud_form-0.6*(1-Cloud_turb))} // max(0,  whichever is greater, 0 or equation

#declare Cloud_Mass =
intersection {
  box {<-20, -10, -20>, <20, 20, 20>} // you can control the shape of the base of the clouds with this
  blob {
    sphere { <0,0,0>, 10,1}
    sphere { <2,6,0>, 5,1}
    sphere { <0,0,0>, 8,1 scale <1,0.7,1> translate <6,1,1>}
    sphere { <0,0,0>, 6,1 scale <1,0.6,1> translate <10,4,-2>}
    sphere { <0,0,0>, 13,1 scale <1,0.5,0.6> translate <-10,3,4>}
    sphere { <0,0,0>, 7,1 scale <1,0.5,0.6> translate<10,0,1>}
    sphere { <0,0,0>, 5,1 scale <1.25,0.5,1> translate<-5,0,-2>}
    threshold 0.001
  }

  texture{pigment{color rgbt 1}}
  interior{
    media{
      method 2
      intervals 3
      scattering{ 5, color rgb <0.13,0.15,0.13>*150 extinction 1.25} // changes colour of clouds raising extinction Darkens Clouds
      density{
        function {Cloud1}
        color_map {
          [0  color rgb 0.0]
          [1  color rgb 0.2]// was 1 lightens the contrast, the bigger the number the higher the contrast // the darker the base the more dramatic .01 whispy 1 too dark 0.05 good .075
        }
      }
    }
  }
  hollow on
}
