// tmwinter.pov
// tom melly - tom@tomandlu.co.uk

#version 3.5;

#include "colors.inc"
#include "functions.inc"
#include "transforms.inc"
#include "strings.inc"
#include "tmwinter.inc"

#declare doRad  = true;
#declare doTree = true;
#declare doWall = true;
#declare doSnow = true;

#if(doRad)
  global_settings {
    assumed_gamma 1.0
    ambient_light 0.01
    radiosity {
      pretrace_start    0.08
      pretrace_end      0.01
      count             150
      nearest_count     10 
      error_bound       0.75
      recursion_limit   1   
      low_error_factor  0.8 
      gray_threshold    0.5 
      minimum_reuse     0.015
      brightness        1.0  
      always_sample     off
      adc_bailout 0.01/2
      normal on              
      max_sample 1.0         
    }
  }
  sphere{
    0,1000
    inverse
    pigment{
      wrinkles turbulence 0.15 scale 300
      pigment_map{
        [0.00 Gray50]
        [0.15 Gray60]
        [0.20 Gray70]
        [0.30 Gray80]
        [0.50 Gray60]
        [0.75 Gray50]
        [1.00 Gray40]
      }
    }
    finish{ambient 50}
  }
#else
  sphere{
    0,1000
    inverse
    pigment{
      wrinkles turbulence 0.15 scale 300
      pigment_map{
        [0.00 Gray65]
        [0.15 Gray70]
        [0.20 Gray75]
        [0.30 Gray80]
        [0.50 Gray70]
        [0.75 Gray65]
        [1.00 Gray60]
      }
    }
  }
  light_source{0 color 1 translate <0,12,-25> shadowless}
#end

camera
{
	location <0,12,-25>
	look_at y*12
}

#declare fn_Land = function(x,y,z){y - f_noise3d(x/1,0,z/1)/5 + f_noise3d(x/15,0,z/15)*5 - 5}
#declare Land =
isosurface {
  function { fn_Land(x,y,z) }
  contained_by { box{<-35,-5,-25>,<35,5,20>}}
  accuracy 0.001
  max_gradient 4
}

#if(doWall)
  #declare Ground = object{Land}
  #declare WallHi = 7;
  #declare WallStart = -20;
  #declare WallEnd = 20;
  MakeWall(WallHi, WallStart, WallEnd, 3452)
  #declare Wall = object{Wall translate y*-0.5};
  object{Wall}
  #if(doSnow)blob{MakeSnow(Wall, 5000, 235, 20, 15, 50, 5, 0.2) texture{SnowTex}}#end
  
  #declare Ground = object{Land translate z*-1}
  MakeWall(WallHi, WallStart, WallEnd, 874)
  #declare Wall = object{Wall translate z*1 translate y*-0.5};
  object{Wall}
#end

object{Land texture{SnowTex}}

#if(doTree)
  
  Make_Tree(50000, 155246, 5, 40, 8, 0.4, 30, 6) 
  #declare Tree =
  object{
    Tree scale 0.75 rotate z*-15 rotate x*15
    texture{
      treeTexture
      scale 1
    }
  }
  #if(doSnow)
    union{
      object{Tree}
      blob{
        MakeSnow(Tree,2000,7632,100,100,150,150,0.5)
        texture{SnowTex}
      }
      translate<0,0,12>
    }
  #else
    object{Tree translate<0,0,12>}
  #end  
#end

sphere{
  0,1
  pigment{
    gradient z scale 2 translate z*-1
    pigment_map{
      [0.0 Gray25]
      [1.0 rgbf 1]
    }
  }
  scale 999
  inverse
  rotate y*30
}

