// ======================================
// Persistence of Vision Ray Tracer 3.1
// ======================================
// gtlamp.pov by Gilles Tran - March 1999
// ======================================
// XIXe Paris street lamp
// Visit the Book of Beginnings http://www.mediaport.net/Artichaud/Tran/gtran.en.html
// ======================================

#declare Do_Lamp_Scene = false;
//#include "textures.inc"
//#include "colors.inc"

// ======================================
// MakeStreetLamp macro
// ======================================
// This macro creates a street lamp such as the ones you could find in Paris
// in the XIXe century. It's a totally imaginary model though.
// This lamp is used in the pictures "Mouseless" and "Learning to fly".
// It can be turned on and off (allume variable)
// It can have a halo within and around the head of the lamp (not too realistic I fear)
// 
#macro MakeStreetLamp(typeL,allume,colLum,areaL,haloL,haloSize,haloTurb,haloStrength,fadeL,txtVL,txtL)
//#declare typeL=1; // 1=complex 2=simple 3=no post (test purpose)
//#declare allume=1; // 0=light off 1=light on
//#declare colLum=rgb<0.8,0.9,1.3>; // light color
//#declare areaL=0; //  0=area light off 1=area light on
//#declare haloL=1; //  0=halo off 1=halo on
//#declare haloSize=6; // outer halo size
//#declare haloTurb=0.1; // outer halo turbulence
//#declare haloStrength=0.7; // inner and outer halo intensity (outer halo is 50% inner halo intensity)
//#declare fadeL=200; // light fade distance
//#declare txtVL=texture{pigment{Clear} finish{ambient 0 diffuse 0}} // glass texture
//#declare txtL=texture{pigment{ForestGreen*0.3} finish{ambient 0.1 specular 1 roughness 0.05}} // paint texture
//#declare SideDeco = height_field{gif   "sidedeco.gif"} // decoration for lamp sides
//#declare SideDeco = box{0,<1,0.1,1>} // minimum side decoration

#local eHeadLamp=0.25;
#local eHeadLamp2=0.17;
#local rHeadLamp1=1.6;
#local rHeadLamp2=2.3;
#local rHeadLamp3=1.6;
#local yHeadLamp2=5;
#local yHeadLamp3=7;
#local yArmLamp=1.5;

//================================
// Lamp glass
//================================
#local rTL1=rHeadLamp1-eHeadLamp2;
#local rTL2=rHeadLamp2-eHeadLamp2;
#local rTL3=rHeadLamp3;
#local yTL1=eHeadLamp;
#local yTL2=yHeadLamp2;
#local yTL3=yHeadLamp3;
#local DensityLamp=density {
boxed       
      color_map{
        [0.0 Black]
        [1.0 colLum*haloStrength]
      }
}
            
#local mediaLamp=
media {     
        emission haloStrength
        intervals 5 samples 1, 5
        confidence 0.9999
        variance 1/10
        density {DensityLamp}
        scale <rTL2,yTL3*0.5,rTL2> translate y*yTL3*0.5
    }                                                  

#local DensityHalo=density {
spherical       
      turbulence haloTurb
      color_map{
        [0.0 Black]
        [1.0 colLum*haloStrength*.5]
      }
}

             
#local mediaHalo=
media {     
        emission haloStrength*0.5
        intervals 5 samples 1, 5
        confidence 0.9999
        variance 1/10
        density {DensityHalo}
    }                                                  

#declare LampHalo=
sphere{0,1 texture{pigment{Clear} finish{ambient 0 diffuse 0}}
        interior{media{mediaHalo}}
        hollow no_shadow
        scale <1,1.3,1>*haloSize
        translate y*yTL3*0.5
        }

#local GlassLamp=
difference{
box{<-rTL2,0,-rTL2>,<rTL2,yTL3,rTL2>}
plane{x,0 rotate -z*degrees(atan2(rTL2-rTL3,yTL3-yTL2)) translate <-rTL2,yTL2,0>}
plane{x,0 rotate z*degrees(atan2(rTL2-rTL1,yTL2-yTL1)) translate <-rTL2,yTL2,0>}
union{
        plane{x,0 rotate -z*degrees(atan2(rTL2-rTL3,yTL3-yTL2)) translate <-rTL2,yTL2,0>}
        plane{x,0 rotate z*degrees(atan2(rTL2-rTL1,yTL2-yTL1)) translate <-rTL2,yTL2,0>}
        rotate y*-90
}
union{
        plane{x,0 rotate -z*degrees(atan2(rTL2-rTL3,yTL3-yTL2)) translate <-rTL2,yTL2,0>}
        plane{x,0 rotate z*degrees(atan2(rTL2-rTL1,yTL2-yTL1)) translate <-rTL2,yTL2,0>}
        rotate y*180
}
union{
        plane{x,0 rotate -z*degrees(atan2(rTL2-rTL3,yTL3-yTL2)) translate <-rTL2,yTL2,0>}
        plane{x,0 rotate z*degrees(atan2(rTL2-rTL1,yTL2-yTL1)) translate <-rTL2,yTL2,0>}
        rotate y*270
}
texture{txtVL}                                                  
#if (haloL>0)
        interior{media{mediaLamp}}
#end        
hollow
no_shadow     

translate -y*yTL3*0.5            
scale 1.2
translate y*yTL3*0.5            
                
}
//================================
// Montant Head Lampadaire
//================================
#local MontantHeadLamp=union{
        cylinder{<-rHeadLamp1+eHeadLamp2,0,-rHeadLamp1+eHeadLamp2>,<-rHeadLamp2,yHeadLamp2+eHeadLamp+eHeadLamp2*1.5,-rHeadLamp2>,eHeadLamp2}
        cylinder{<-rHeadLamp2+eHeadLamp2,yHeadLamp2,-rHeadLamp2+eHeadLamp2>,<-rHeadLamp3,yHeadLamp3+eHeadLamp+eHeadLamp2*1.5,-rHeadLamp3>,eHeadLamp2}
        sphere{0,1 translate y scale eHeadLamp2*1.5 translate <-rHeadLamp2,yHeadLamp2+eHeadLamp,-rHeadLamp2>}
        sphere{0,1 translate y scale eHeadLamp2*1.5 translate <-rHeadLamp3,yHeadLamp3+eHeadLamp,-rHeadLamp3>}
}
//================================
//Decorative leaf
//================================
#local Leaf=intersection{
        difference{sphere{0,1}sphere{0,0.99}}
        plane{z,0 rotate y*20 inverse}        
        plane{z,0 rotate -y*20}        
        translate <-0.2,1,0>          
        rotate z*70
}                   
//================================
// Collar of leaves
//================================
#local CollarLeaves=union{  
                #local teta=0;                                        
                #while (teta<360)
                object{Leaf rotate z*50 translate -x rotate y*teta}
                #local teta=teta+18;
                #end
}                
//================================
// Decorative spiral
//================================
#local rSpiral0=3;            
#local rSpiral=rSpiral0;            
#local eSpiral=0.4;            
#local eSpiral1=eSpiral;            
#local etetaSpiral=pi/30;

#local tetaSpiral=etetaSpiral;
#local pt1=x*rSpiral;
#local SpiralLamp=union{
        union{
                #while (rSpiral>0.2)          
                        #local pt2=<cos(tetaSpiral),sin(tetaSpiral),0>*rSpiral;
                        #local eSpiral2=eSpiral1-0.001;
                        cone{pt1,eSpiral1,pt2,eSpiral2}
                        #local rSpiral=rSpiral-0.025;
                        #local tetaSpiral=tetaSpiral+etetaSpiral;
                        #local pt1=pt2;           
                        #local eSpiral1=eSpiral2;           
                #end  
        }                  
        intersection{
                torus{rSpiral0*1.5,eSpiral rotate x*90}
                plane{x,0}
                plane{y,0}
                translate x*(rSpiral0*2.5)
        }                     
        translate -x*(rSpiral0*2.5)
        scale 1.5
}                
//================================
// Element6 Spiral sets
//================================
#local ElementLamp6=union{                          
        object{SpiralLamp }
        object{SpiralLamp rotate y*72}
        object{SpiralLamp rotate y*144}
        object{SpiralLamp rotate y*216}
        object{SpiralLamp rotate y*288}
        translate y*rSpiral*1.5
        scale 0.3
}                      
//================================
// Lamp "meche"
//================================
#local MecheLamp=union{
        sphere{0,0.5}
        cylinder{-10*y,4*y,1.5}
        cylinder{4*y,<2,15,-1>,0.15}
        union{
                torus{0.6,0.3}
                cylinder{x*0.6,<6,-1,0>,0.14}
                torus{0.7,0.2 rotate x*-90 translate <6.7,-1,0>}
                translate y*4
        }
}
//================================
// Lamp head
//================================
#local HeadLamp=union{            
        object{GlassLamp}
        #if (haloL=1) 
                object{LampHalo}
        #end
        difference{
                box{<-rHeadLamp1,0,-rHeadLamp1>,<rHeadLamp1,eHeadLamp,rHeadLamp1>}
                box{<-rHeadLamp1+eHeadLamp,-eHeadLamp,-rHeadLamp1+eHeadLamp>,<rHeadLamp1-eHeadLamp,2*eHeadLamp,rHeadLamp1-eHeadLamp>}
        }                     
        difference{
                box{<-rHeadLamp2-eHeadLamp,0,-rHeadLamp2-eHeadLamp>,<rHeadLamp2+eHeadLamp,eHeadLamp,rHeadLamp2+eHeadLamp>}
                box{<-rHeadLamp2+eHeadLamp,-eHeadLamp,-rHeadLamp2+eHeadLamp>,<rHeadLamp2-eHeadLamp,2*eHeadLamp,rHeadLamp2-eHeadLamp>}
                translate yHeadLamp2*y
        }                     
        box{<-rHeadLamp3-eHeadLamp*2,0,-rHeadLamp3-eHeadLamp*2>,<rHeadLamp3+eHeadLamp*2,eHeadLamp,rHeadLamp3+eHeadLamp*2> translate yHeadLamp3*y}
        object{MontantHeadLamp}
        object{MontantHeadLamp rotate y*90}
        object{MontantHeadLamp  rotate y*180}
        object{MontantHeadLamp  rotate y*270}   
        union{  
                union{        
                        intersection {
                                plane { y, 0.5}
                                quadric {<1.0, -1.0,  1.0>,<0.0,  0.0,  0.0>,<0.0,  0.0,  0.0>,-0.3}
                                plane { y, -1 inverse}             
                                translate y
                        }        
                        intersection{     
                                sphere{0,0.8 scale <1,0.8,1>}
                                plane{y,0 inverse}
                                translate y*1.5
                        }
                        scale <1.7,1,1.7>
                }       
                torus{1.4,0.1 translate y*1.5}
                sphere{0,0.4 translate y*2.5}
                union{
                        object{Leaf}
                        object{Leaf rotate  y*72}
                        object{Leaf rotate y*144}
                        object{Leaf rotate y*216}
                        object{Leaf rotate y*288}
                        translate y*2.6
                }
                translate y*(yHeadLamp3+eHeadLamp)
        } 
        object{MecheLamp scale 0.4 translate -y*yArmLamp}

}                


//================================
// Element5
//================================
#local ElementLamp5=lathe{
  cubic_spline 10,
  <-3, 0>, <0, 0>, <2.5, 0.5>,
  <4, 0.9>, <3.9, 2>,
  <2,3>,<3,4>,<3,5>,<0,6>,<-3,6>
  scale <0.3,0.5,0.3>
}

//================================
// Element4
//================================
#local partElementLamp4=union{
        lathe{cubic_spline 13,<0,0>,<1,0>,<1.3,0.2>,<1.6,1>,<1,2>,<0.5,10>,<0.6,15>,<0.7,15.3>,<0.5,16>,<0.6,19>,<0.9,20>,<0.5,20.5>,<0,21> scale <0.3,1,0.3>}
        torus{0.3,0.2 translate y*2}
        torus{0.2,0.1 translate y*14.9}
        translate x*0.5
        rotate z*1
}
#local ElementLamp4=union{
        #local teta=0;                                        
        #while (teta<360)
                object{partElementLamp4 rotate y*teta}
                #local teta=teta+36;
        #end
       
}

//================================
// Element3
//================================
#local SmallFootLamp=blob{
        threshold 1.3

        sphere{0,4,4 translate x*4}
        cylinder{x*4,x*10-y*4,2,3}
        sphere{0,3,4 translate x*10-y*4}
        cylinder{x*10-y*4,x*12-y*10,2,3}

        sphere{0,3,2 translate 2*x translate x*13-y*10}
        cylinder{0,2*x+y,1.5,3 translate 2*x translate x*13-y*10}
        sphere{0,2,2 translate 2*x+2*y translate 2*x translate x*13-y*10}
        cylinder{2*x+2*y,5*x,1,3 translate 2*x translate x*13-y*10}
        sphere{0,3,2 scale <2,0.4,1> translate 6*x translate 2*x translate x*13-y*10}

        sphere{0,3,2 translate x rotate y*50 translate x*13-y*10}
        cylinder{0,2*x+y,1.5,3 translate x rotate y*50 translate x*13-y*10}
        sphere{0,2,2 translate 2*x+2*y translate x rotate y*50 translate x*13-y*10}
        cylinder{2*x+2*y,5*x,1,3 translate x rotate y*50 translate x*13-y*10}
        sphere{0,3,2 scale <2,0.4,1> translate 6*x translate x rotate y*50 translate x*13-y*10}

        sphere{0,3,2 translate x rotate -y*50 translate x*13-y*10}
        cylinder{0,2*x+y,1.5,3 translate x rotate -y*50 translate x*13-y*10}
        sphere{0,2,2 translate 2*x+2*y translate x rotate -y*50 translate x*13-y*10}
        cylinder{2*x+2*y,5*x,1,3 translate x rotate -y*50 translate x*13-y*10}
        sphere{0,3,2 scale <2,0.4,1> translate 6*x translate x rotate -y*50 translate x*13-y*10}
        translate y*10
        scale 0.2
        translate x*0.5
}
#local partElementLamp3=union{
        lathe{cubic_spline 10,<0,-1>,<0.5,0>,<3,0.5>,<3.4,1.5>,<2,3>,<2,4.5>,<1.3,5>, <1.6,5.5>,<1.2,5.8>,<0,6> scale <0.5,1,0.5>}
        lathe{cubic_spline 10,<0,-1>,<0.5,0>,<3,0.5>,<3.4,1.5>,<2,3>,<2,4.5>,<1.3,5>, <1.6,5.5>,<1.2,5.8>,<0,6> scale <0.55,1,0.2>}
        torus{0.4,0.2 translate y*6}
        torus{1.6,0.05 translate y*2}
        torus{1,0.2 scale <1,2,1>}
        union{
                torus{0.3,0.1 rotate z*80}
                sphere{0,0.12 scale <3,1,1>}
                translate <-2,3.2,0>
        }
        union{
                torus{0.3,0.1 rotate z*80}
                sphere{0,0.12 scale <3,1,1>}
                translate <-2,4.2,0>
        }
        translate x*0.5
}

#local ElementLamp3=union{
        difference{
                cylinder{0,y*2,1}
                #local teta=0;                                        
                #while (teta<360)
                        sphere{0,1 scale <1,2.5,2>*0.3 translate -x rotate y*teta translate y}
                        #local teta=teta+36;
                #end
                translate y*8
        }
        object{CollarLeaves scale <1,-1,1>*0.5 translate y*8}
        torus{1,0.2 translate y*10}
        union{  
                #local teta=0;                                        
                #while (teta<360)
                        object{partElementLamp3 rotate y*teta}
                        #local teta=teta+36;
                #end
                translate y*2 
        }       
        union{  
                #local teta=0;                                        
                #while (teta<360)
                        object{SmallFootLamp rotate y*teta}
                        #local teta=teta+72;
                #end
        }       
}
//================================
// Element1
//================================
#local rEl1=6;
#local partElementLamp1=union{         
        box{<-rEl1-0.5,0,-tan(pi/5)*(rEl1+0.5)>,<0,0.7,tan(pi/5)*(rEl1+0.5)> translate y*13.5}

        cylinder{-tan(pi/5)*z*(rEl1+0.5),tan(pi/5)*z*(rEl1+0.5),0.2 translate -x*(rEl1+0.5)  translate y*14}
        sphere{tan(pi/5)*z*(rEl1+0.5),0.2 translate -x*(rEl1+0.5)  translate y*14}
                                               
        cylinder{-tan(pi/5)*z*(rEl1+0.5),tan(pi/5)*z*(rEl1+0.5),0.25 translate -x*(rEl1+0.5)  translate y*13.75}
        sphere{tan(pi/5)*z*(rEl1+0.5),0.25 translate -x*(rEl1+0.5)  translate y*13.75}
        
        cylinder{-tan(pi/5)*z*(rEl1+0.5),tan(pi/5)*z*(rEl1+0.5),0.15 translate -x*(rEl1+0.5)  translate y*13.625}
        sphere{tan(pi/5)*z*(rEl1+0.5),0.15 translate -x*(rEl1+0.5)  translate y*13.625}

        box{<-rEl1-0.5,0,-tan(pi/5)*(rEl1+0.5)>,<-rEl1,1,tan(pi/5)*(rEl1+0.5)> translate y*12.5}
        
        cylinder{-tan(pi/5)*z*(rEl1+0.5),tan(pi/5)*z*(rEl1+0.5),0.15 translate -x*(rEl1+0.5)  translate y*12.5}
        sphere{tan(pi/5)*z*(rEl1+0.5),0.15 translate -x*(rEl1+0.5)  translate y*12.5}

        cylinder{-tan(pi/5)*z*(rEl1+0.5),tan(pi/5)*z*(rEl1+0.5),0.25 translate -x*(rEl1+0.5)  translate y*12.25}
        sphere{tan(pi/5)*z*(rEl1+0.5),0.25 translate -x*(rEl1+0.5)  translate y*12.25}
        
        cylinder{-tan(pi/5)*z*rEl1,tan(pi/5)*z*rEl1,0.5 translate -x*rEl1  translate y*12}
        sphere{tan(pi/5)*z*rEl1,0.5 translate -x*rEl1  translate y*12}
        
        object{SideDeco translate -x*0.5 scale <tan(pi/5)*rEl1*2,0.1,7> rotate x*-90 rotate y*90 translate -x*rEl1 translate y*4.5}
        cylinder{0,y*7,0.3 translate <-rEl1+0.2,4.5,-tan(pi/5)*rEl1>}
        
        cylinder{-tan(pi/5)*z*rEl1,tan(pi/5)*z*rEl1,0.25 translate -x*rEl1  translate y*4.25}
        sphere{tan(pi/5)*z*rEl1,0.25 translate -x*rEl1  translate y*4.25}
        
        cylinder{-tan(pi/5)*z*(rEl1+0.25),tan(pi/5)*z*(rEl1+0.25),0.25 translate -x*(rEl1+0.25)  translate y*4}
        sphere{tan(pi/5)*z*(rEl1+0.25),0.25 translate -x*(rEl1+0.25)  translate y*4}
        
        difference{
                intersection{
                        box{<-rEl1-1,0,-tan(pi/5)*(rEl1+0.5)*2>,<-rEl1,0.5,tan(pi/5)*(rEl1+0.5)*2>}
                        plane{z,0 rotate y*36}
                        plane{z,0 rotate -y*36 inverse}
                }
                cylinder{-tan(pi/5)*z*(rEl1+1)*3,tan(pi/5)*z*(rEl1+1)*3,0.5 translate -x*(rEl1+1)  translate y*0.5}               
                translate y*3.5
        } 
        
        cylinder{-tan(pi/5)*z*(rEl1+1),tan(pi/5)*z*(rEl1+1),0.25 translate -x*(rEl1+1)  translate y*3.25}
        sphere{tan(pi/5)*z*(rEl1+1),0.25 translate -x*(rEl1+1)  translate y*3.25}
        
        box{<-rEl1-1,0,-tan(pi/5)*(rEl1+1)>,<-rEl1,0.5,tan(pi/5)*(rEl1+1)> translate y*2.5}
        
        cylinder{-tan(pi/5)*z*(rEl1+1),tan(pi/5)*z*(rEl1+1),0.25 translate -x*(rEl1+1)  translate y*2.25}
        sphere{tan(pi/5)*z*(rEl1+1),0.25 translate -x*(rEl1+1)  translate y*2.25}
        
        cylinder{-tan(pi/5)*z*(rEl1+1),tan(pi/5)*z*(rEl1+1),0.5 translate -x*(rEl1+1)  translate y*1.5}
        sphere{tan(pi/5)*z*(rEl1+1),0.5 translate -x*(rEl1+1)  translate y*1.5}
        
        box{<-rEl1-1.5,0,-tan(pi/5)*(rEl1+1.5)>,<-rEl1,1.5,tan(pi/5)*(rEl1+1.5)>}
}
#local ElementLamp1=union{
        #local teta=0;                                        
        #while (teta<360)
                object{partElementLamp1 rotate y*teta}
        #local teta=teta+72;
        #end

} 
//================================
// Element7
//================================
#local ElementLamp7=lathe{
  cubic_spline 11,
  <4, -1>, <5, 0>, <4, 1>,
  <3.4, 2>, <3.4, 2.1>,<4,2.5>
  <3.7,3>,<3,4>,<2,5>,<2,6>,<2.3,7>
  scale <0.5,48/6,0.5>
}
//================================
// Lumire
//================================
#local LumLamp=light_source{0 color colLum 
        #if (areaL=1)
                area_light <2, 0, 0> <0, 0, 2> 4, 4 adaptive 1 jitter 
        #end
        fade_distance fadeL fade_power 2
        }
        

//================================
// Lampadaire
//================================
#if (typeL<3)
union{  
        union{      
                #if (allume=1) 
                        sphere{
                          0,1
                          scale <0.5,1,0.5> 
                          pigment{rgbf 1}
                          hollow
                          interior{
                            media{
                              method 1
                              emission 10
                              density{wrinkles}
                            }
                          }
                          photons{pass_through}
                          translate <0,9,0>
                        }
                        object{LumLamp scale 10 translate y*10}
                #end
                object{HeadLamp translate y*6.5}
                
                #if (typeL=1)        
                        object{ElementLamp6 translate y*4}
                #end
                object{ElementLamp5}
                object{CollarLeaves scale 0.5 translate y*0.5}
                
                translate y*47.7
        }       
#if (typeL=1)        
        object{ElementLamp4 scale <2,1,2> translate y*28.2}
        object{ElementLamp3 scale 1.5 translate y*14.2}
        object{ElementLamp1}
#else
        object{ElementLamp7}
#end
        texture{txtL} 
}            
#else
        #if (allume=1)
                sphere{0,1 pigment{White} finish{ambient 1} translate y*57.7}
                object{LumLamp scale 10 translate y*57.7}
            
        #end

#end
#end
// ======================================
// Lamp example
// ======================================
#if(Do_Lamp_Scene)
  #declare PdV=<0, 20, -160.0>;
  #declare PdA=<0, 30,  0.0>;                                     
  camera{
    location  <0,2,-15>
  }                
  light_source{PdV color White*0.3} 
  light_source{<1000,1000,-1000> color White} 
  
  #declare typeL=1; // 1=complex 2=simple 3=light only
  #declare allume=1; // 0=light off 1=light on
  #declare colLum=rgb<1.3,1,0.7>; // light color
  #declare areaL=1; //  0=area light off 1=area light on
  #declare haloL=1; //  0=halo off 1=halo on
  #declare haloSize=6; // outer halo size
  #declare haloTurb=0.1; // outer halo turbulence
  #declare haloStrength=0.7; // inner and outer halo intensity (outer halo is 50% inner halo intensity)
  #declare fadeL=200; // light fade distance
  #declare txtVL=texture{pigment{Clear} finish{ambient 0 diffuse 0}} // glass texture
  #declare txtL=texture{pigment{ForestGreen*0.7} finish{ambient 0.1 specular 1 roughness 0.05}} // paint texture
  
  //#declare SideDeco = height_field{gif   "sidedeco.gif"} // decoration for lamp sides
  
  #declare SideDeco = box{0,<1,0.1,1>} // minimum side decoration
  
  //#macro MakeStreetLamp(typeL,allume,colLum,areaL,haloL,haloSize,haloTurb,haloStrength,fadeL,txtVL,txtL)
  
  #declare Lamp1=object{MakeStreetLamp(typeL,allume,colLum,areaL,haloL,haloSize,haloTurb,haloStrength,fadeL,txtVL,txtL)}
  object{Lamp1 scale 0.075 rotate y*35}
  plane{y,0 pigment{White*0.2}}
  background{rgb<0,0,0.3>}
  //background{SkyBlue}
  
  cylinder{0, y*5, 0.25 translate x*1 pigment{Red}}

#end

