// Persistence of Vision Ray Tracer Scene Description File
// File: tmworld.pov
// Vers: 3.5
// Desc: Lucy's Arrival - entry for IRTC February 2002 round "Worlds within Worlds"
// Date: 22/2/2002
// Auth: Tom Melly

#version 3.5;

#declare Main_Scene = true;

#include "colors.inc"
#include "textures.inc"
#include "functions.inc"
#include "transforms.inc"
#include "woods.inc"

#include "tmworld.inc"
#include "tree.inc"
#include "furtex.inc"
#include "cupboard.inc"
#include "makelamp.inc"

#local Run_Full         = true;

#if(Run_Full)
  #local Do_Land        = true;  #local Do_Trees       = true;  #local Do_Lamp        = true;
  #local Do_Cupboard    = true;  #local Do_Stars       = true;  #local Do_X_Trees     = true;
  #local Do_Lucy        = false;  #local Do_Photons     = true;
#else
  #local Do_Land        = false;
  #local Do_Trees       = false; // takes presc. over test-tree
  #local Do_Lamp        = true;
  #local Do_Cupboard    = true;
  #local Do_Stars       = true;
  #local Do_X_Trees     = false;
  #local Do_Lucy        = false;
  #local Do_Photons     = true;
#end

#local L_Blobs        = 150; //150
#local C_Blobs        = 200; //150
#local Do_Drops       = false;
#local Test_Tree      = false;
#local Tree_Vars      = 5; //5;
#local Num_Trees      = 15000;//15000; // 20000
#local Min_Tree_Z     = 3;
#local TXZ_Test       = 1; // 1 for normal
#declare Snow_Qual    = 1;// 0.01; // 1 for normal
#local Light_Str      = 0.15; //0.3

#declare Grnd_DiffV   = array[200];
#declare Grnd_DiffXZS = array[200];
#declare GDC          = 0;

global_settings {
  assumed_gamma 1.0
  max_trace_level 10
  ambient_light 0.001*Light_Str
  
  #if(Do_Photons)
    photons {
      spacing 0.01                 // specify the density of photons
    }
  #end
}

#local CamY = 5;
camera {
  location  <0.0,CamY,0.0>
  look_at   <0.0,CamY/2,20.0>
}

light_source{
  <0,0,0>
  color rgb Light_Str*0.75
  translate <0,CamY,0>
  shadowless
  photons { reflection off refraction off}
}

light_source {
  <0, 0, 0>
  color rgb <1.0, 1.0, 0.8>*Light_Str //1
  translate <150000,200000,-100000>

  area_light <0, 0, 0>, <10000,10000,-10000>, 50, 50
  adaptive 1
  jitter
}

#if(Do_Stars)
  #local SBG = pigment{gradient y pigment_map{[0 rgb<0,0,0.005>][1/20000 Black]} scale 2500000}
  #declare Stars = pigment{
    granite scale 1 turbulence 0.5
    pigment_map{[0.2 White][0.2 SBG]}
  }
  
  sphere {
    0,2500000
    pigment{
      bozo scale 5000
      pigment_map{
        [0.4 SBG]
        [1.0 Stars]
      }
    }
    finish{ambient 1/0.0001}
    inverse
  }
#end

#declare BaseRockTex =
texture{
  pigment{granite scale 0.25 pigment_map{[0.0 Black][0.5 Gray10][1.0 Gray50]}}
  finish{ambient 0 diffuse 0.8}
  normal{
    average
    normal_map{
      [dents 15 scale 1 ]
      [granite 15 scale 1 turbulence 0.25]
      [marble 15 scale 1 turbulence 0.5]
      [crackle 15 scale 1 turbulence 0.5]
    }
  }
}

#declare SnowTex =
texture{
  pigment{rgb <0.5,0.5,1>} //<0.9,0.9,1.9>}
  finish{ambient 0.10 diffuse 0.85}
  normal{
    average 2
    normal_map{
      [dents 2 scale 1/25]
      [bozo 1 scale 4 turbulence 0.75]
    }
  }
}

#declare RockTex =
texture{
  marble rotate z*90 scale 10 turbulence 0.5
  texture_map{
    [0.9 BaseRockTex scale 0.01]
    [0.9 bozo scale 10 texture_map{[0.5 BaseRockTex][0.5 SnowTex]}]
  }
}  

#declare GBaseTex =
texture{
  slope y
  texture_map{
    [0.64 RockTex] // BaseRockTex scale 0.01] //[0.64 RockTex]
    [0.66 SnowTex]
  }
}

#declare GroundMFFunc = function(x,y,z){f_ridged_mf(x,y,z, 0.9, 5, 10, 0.75, 1, 0)}
#declare GroundFunc = function(x,y,z){
  y + 0.0 - 
  (GroundMFFunc
    (x/15,0,z/15) *
    (min(((x/10)^2 + (z/10)^2), 50) + 0)
  )
}

#local FGLY = 0;
#local FGHY = 2000;
#local NGLY = 0;
#local NGHY = 2.5;

#if(FGLY < NGLY)
  #local GLY = FGLY/100;
#else
  #local GLY = NGLY/100;
#end

#if(FGHY > NGHY)
  #local GHY = FGHY/100;
#else
  #local GHY = NGHY/100;
#end

#declare Ground =
isosurface{
  function{GroundFunc(x,y,z)}
  contained_by{box{<-35,GLY,0>,<35,GHY,50>}}
  accuracy 0.001
  max_gradient 10 // 1 for ng
  scale 100
  translate z*-100
}

#declare Far_Ground =
  intersection{
    object{Ground}
               box{<-3500,FGLY,105.01>,<3500,FGHY,4901>}
    bounded_by{box{<-3500,FGLY,105.01>,<3500,FGHY,4901>}}
  }
  
#declare Near_Ground =

  intersection{
    object{Ground}
               box{<-70,NGLY,-50>,<70,NGHY,105>}
    bounded_by{box{<-70,NGLY,-50>,<70,NGHY,105>}}
  }
  
#if(Do_Trees)
  
  #local SnowBlobs = 1500*Snow_Qual;
  #local TreeArray = array[Tree_Vars][3];

  #debug concat("Making trees (", str(Tree_Vars,0,0), " varients)\n")
  
  #declare BarkTex =
  texture{
    pigment{rgb<0.2,0.1,0>}
    normal{agate}
  }
  #declare FolTex =
  texture{
    pigment{wrinkles scale 0.1 pigment_map{[0.6 rgb<0.05,0.2,0>][0.6 rgbf 1]}}
    normal{agate}
  }
  
  #local TRand1 = seed(36462);
  #local TCount1 = 0;
  #while(TCount1 < Tree_Vars)
    #local THT = (rand(TRand1)*4 + 8)*1.5;
    MakeTree(THT,THT/(9+rand(TRand1)*2),rand(TRand1)*10000,BarkTex,FolTex)
    #declare Tree =
    union{
      object{Trunk}
      object{Branches}
      object{Foliage}
    }  
    
    #declare Snow =
    blob{
      MakeSnow(Tree, SnowBlobs,548,200,200,10,10)
      texture{SnowTex}
    }
    
    #declare Tree_A = 
    union{
      object{Trunk}
      object{Branches}
      object{Foliage}
      object{Snow}
      photons{collect off}
    }
    
    #declare Tree_B = 
    union{
      object{Trunk}
      object{Foliage}
      object{Snow}
      photons{collect off}
    }
    #declare Tree_C = 
    union{
      object{Foliage}
      object{Snow}
      photons{collect off}
    }
    
    #local TreeArray[TCount1][0] = object{Tree_A}
    #local TreeArray[TCount1][1] = object{Tree_B}
    #local TreeArray[TCount1][2] = object{Tree_C}
    #local TCount1 = TCount1 + 1;
  
  #end

  #debug "Trees made\n"
  
  #if(Test_Tree)
    object{TreeArray[0][0] translate z*25}
  #else  
    #debug "Positioning trees\n"
    #declare TRand2 = seed(345);
    #local TCount1 = 1;
    union{
      #while(TCount1 < Num_Trees)
        #local XTrans2 = (2200*rand(TRand2) - 1100)*TXZ_Test;
        #local ZTrans2 = (2000*rand(TRand2))*TXZ_Test + Min_Tree_Z;
        #if(abs(XTrans2)/ZTrans2 < 0.65)
          #local TreeSlct = int(rand(TRand2)*Tree_Vars);
          #switch(ZTrans2)
            #range(0,100)
              #local Qual = 0; #break
            #range(100,200)
              #local Qual = 1; #break
            #else
              #local Qual = 2; #break
          #end
          #local ThisTree = TreeArray[TreeSlct][Qual] 
    
          object{
            ThisTree
            #local XZScale = rand(TRand2)/2 + 0.5;
            scale<XZScale, (rand(TRand2)/2 + 0.5)*XZScale, XZScale>
            rotate y*(rand(TRand2) * 360)
          
            #local Inter2 = trace(Ground, <XTrans2, 5000, ZTrans2>, <0,-1,0>);
            translate<XTrans2,Inter2.y-0.15,ZTrans2>
          }
          #if(Qual = 0 & ZTrans2 < 20)
            #declare Grnd_DiffV[GDC] = <XTrans2,Inter2.y,ZTrans2>;
            #declare Grnd_DiffXZS[GDC] = XZScale;
            #declare GDC = GDC + 1;
          #end
          #local TCount1 = TCount1 + 1;
        #end
      #end
    }
    #debug "Trees positioned\n"
  #end
#end

#declare Steps =
height_field {
  tga               // the file type to read (tga/pot/pgm/ppm/png/sys)
  "steps1.tga"     // the file name to read
  smooth //]        // smooth surface normal
  translate <-0.5,-0.5,-0.5>
  scale <12*(4/3),1,12>
  translate z*12
}

#if(Do_Land)

  object{Far_Ground texture{GBaseTex} photons{collect off}}
  union{
    difference{
      object{Near_Ground}
      box{
        0,1
        translate <-0.5,-0.5,-0.5>
        scale <7*(4/3),4,8>
        translate <-1.5,0,10>
      }
    }
    object{Steps scale <1,1,1> translate y*0.85}
    texture{SnowTex}
    bounded_by{box{<-70,NGLY,-50>,<70,NGHY,105>}}
  }
  
#else

  #declare QGrnd =
  plane{y,0.6 texture{GBaseTex}}
  union{
    difference{
      object{QGrnd} // orig
      box{
        0,1
        translate <-0.5,-0.5,-0.5>
        scale <7*(4/3),4,8>
        translate <-1.5,0,10>
      }
    }
    object{Steps scale <1,1,1> translate y*0.85}
    texture{SnowTex}
  }
#end

#if(Do_Lamp)
  #debug "Doing lamp\n"
  #local LXPos = 6;
  #local LZPos = 15;
  #declare typeL=1;                 // 1=complex 2=simple 3=light only
  #declare allume=1;                // 0=light off 1=light on
  #declare colLum=rgb<1.3, 1.2,0.5>;   // light color
  #declare areaL=1;                 //  0=area light off 1=area light on
  #declare haloL=1;                 //  0=halo off 1=halo on
  #declare haloSize=1;              // outer halo size
  #declare haloTurb=0.1;            // outer halo turbulence
  #declare haloStrength=1;        // inner and outer halo intensity (outer halo is 50% inner halo intensity)
  #declare fadeL= 4;                 // light fade distance
  #declare txtVL=texture{pigment{Clear} finish{ambient 0 diffuse 0}} // glass texture
  #declare txtL=texture{pigment{rgb<0.2,0.2,0.4>} finish{ambient 0.1 specular 1 roughness 0.05}} // paint texture
  #declare SideDeco = box{0,<1,0.1,1>} // minimum side decoration
  
  #declare Lamp1=object{
    MakeStreetLamp(typeL,allume,colLum,areaL,haloL,haloSize,haloTurb,haloStrength,fadeL,txtVL,txtL)
    scale 0.1 //0.065
   }
  #local N = <0,0,0>;
  #local LP = trace(Near_Ground,<LXPos, NGHY, LZPos>,<0, NGLY, 0>, N);
  union{
    object{Lamp1}
    blob{
      MakeSnow(Lamp1,L_Blobs,4365,10,4,2,2)
      texture{SnowTex}
    }
    rotate y*35 translate <LXPos,LP.y+0.4,LZPos>
    photons{collect off}
  }
  #debug "Lamp done\n"
#end

#if(Do_Cupboard)
  #debug "Doing cupboard\n"
  #declare Cupboard1 = object{Cupboard translate x*-1.5 translate z*-0.5}
  #declare BlobC = blob{MakeSnow(Cupboard1,C_Blobs,3721,5,5,3,1) texture{SnowTex}}
  union{
    object{Cupboard1}
    object{BlobC}
    scale<-1,1,1>  
  //  scale 1
    rotate<6,0,3>    
    rotate y*-45 translate <-2.75,0.4,10>
  }
  #debug "Cupboard done\n"
#end

#if(Do_X_Trees)
  #debug "Doing X_Trees\n"

  #if(!Do_Trees)

    #local SnowBlobs = 1500*Snow_Qual;
    #local TreeArray = array[Tree_Vars][3];
  
    #declare BarkTex =
    texture{
      pigment{rgb<0.2,0.1,0>}
      normal{agate}
    }
    #declare FolTex =
    texture{
      pigment{wrinkles scale 0.1 pigment_map{[0.6 rgb<0.05,0.2,0>][0.6 rgbf 1]}}
      normal{agate}
    }
  
    #local TRand1 = seed(36972);
    #local TCount1 = 0;
    #local THT = rand(TRand1)*4 + 8;
    MakeTree(THT,THT/(9+rand(TRand1)*2),rand(TRand1)*10000,BarkTex,FolTex)
    #declare Tree =
    union{
      object{Trunk}
      object{Branches}
      object{Foliage}
    }  
    
    #declare Snow =
    blob{
      MakeSnow(Tree, 5, 548,200,200,10,10)
      texture{SnowTex}
    }
    
    #declare Tree_A = 
    union{
      object{Trunk}
      object{Branches}
      object{Foliage}
      object{Snow}
      photons{collect off}
    }
  
  #end
  object{Tree_A translate<17,0,14>} 
  object{Tree_A scale 1.2 rotate y*49 translate<14,0,10>} 
  object{Tree_A scale 0.7 rotate y*120 translate<10,0,5>} 
  #debug "X_Trees done\n"
#end

#if(Do_Lucy)
  #debug "Doing Lucy\n"

  #include "lucy1.inc"
  object{Lucy1 scale 3  rotate y*45 translate<2,0.5,10> photons{collect off}}
  #debug "Lucy done\n"
#end
#debug "Rendering...\n"

