// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.1g.wmp.0.6a
// Desc: Basic Scene Example
// Date: dd/mm/yy
// Auth: Tom Melly, http://www.tomandlu.co.uk, tom@tomandlu.co.uk
//

#version unofficial MegaPov 0.6;
#declare myShiny =
finish{
  specular 1 roughness 0.0005 reflection 0.3
  irid{0.2 thickness 0.01 turbulence 0.2}
}

#declare blue_pearl =
sphere{
  0, 0.6
  scale<1/1.25,1,4>
  pigment{rgb<0.75,0.75,1>}
  finish{myShiny}
}
#declare white_pearl =
sphere{
  0, 1/2
  scale<1/1.25,1,4>
  pigment{rgb<1,1,0.9>}
  finish{myShiny}
}
#declare green_pearl =
sphere{
  0, 1/2
  scale<1/1.25,1,4>
  pigment{rgb<0.85,1,0.85>}
  finish{myShiny}
}

#init_3d_spline {"Necklace_Spline1",
  <-0.001,-5,5>,
  <-7,2.5,-2>,
  <-8,-15,-8>,
  <0,-60,-10>,
  <7,-15,-8>,
  <6,1/2,1>,
  <0.001,-5,5>,
}

#declare bead_count = 0;
#while(bead_count<1)
  object{
    white_pearl
    translate eval_3d_spline ("Necklace_Spline1", bead_count)
    translate<1,86,-30> //z was -35
  }
  #declare bead_count = bead_count + 0.005;
#end  

#init_3d_spline {"Necklace_Spline2",
  <-0.001,-5,5>,
  <-5,1,-1>,
  <-6,-15,-8>,
  <0,-50,-10>,
  <6,-15,-7>,
  <5,0,1>,
  <0.001,-5,5>,
}

#declare bead_count = 0;
#while(bead_count<1)
  object{
    blue_pearl
    translate eval_3d_spline ("Necklace_Spline2", bead_count)
    translate<1,86,-29> //z was -35
  }
  #declare bead_count = bead_count + 0.0075;
#end  

#init_3d_spline {"Necklace_Spline3",
  <-0.001,-5,5>,
  <-4,1,-1>,
  <-5,-15,-8>,
  <0,-35,-10>,
  <5,-12,-4>,
  <5,-5,-4>,
  <4.5,2,0>,
  <0.001,-5,5>,
}

#declare Switch = 0;
#declare bead_count = 0;
#while(bead_count<1)
  sphere{
    eval_3d_spline ("Necklace_Spline3", bead_count), 0.5
    #if(Switch = 1)
      #declare this_pig = rgb<1,0.25,0.25>;
      #declare Switch = 0;
    #else
      #declare this_pig = rgb<1,1,1>;
      #declare Switch = 1;
    #end
    pigment{this_pig}
    translate<1,86,-30> //z was -35
  }
  #declare bead_count = bead_count + 0.01;
#end  

#init_3d_spline {"Necklace_Spline4",
  <-0.001,-5,5>,
  <-4,1,-1>,
  <-5,-15,-7>,
  <0,-35,-7>,
  <4.5,-12,-4>,
  <4.5,-5,-4>,
  <4.5,2,0>,
  <0.001,-5,5>,
}

#declare bead_count = 0;
#while(bead_count<1)
  sphere{
    eval_3d_spline ("Necklace_Spline4", bead_count), 0.5
    #if(Switch = 1)
      #declare this_pig = rgb<0.5,1,0.5>;
      #declare Switch = 0;
    #else
      #declare this_pig = rgb<1,1,1>;
      #declare Switch = 1;
    #end
    pigment{this_pig}
    scale<1, 4/5,1>
    translate<1,87,-30> //z was -35
  }
  #declare bead_count = bead_count + 0.01;
#end  

#init_3d_spline {"Necklace_Spline5",
  <-0.001,-5,5>,
  <-4,1/2,-1>,
  <-5,-15,-7>,
  <0,-35,-5>,
  <3.5,-12,-5>,
  <3.75,-5,-5>,
  <4,2,0>,
  <0.001,-5,5>,
}

#declare bead_count = 0;
#while(bead_count<1)
  sphere{
    eval_3d_spline ("Necklace_Spline5", bead_count), 0.5
    #if(Switch = 1)
      #declare this_pig = rgb<1,1/2,1/3>;
      #declare Switch = 0;
    #else
      #declare this_pig = rgb<1,1,1>;
      #declare Switch = 1;
    #end
    pigment{this_pig}
    scale<1, 3/5,1>
    translate<1,88,-30> //z was -35
  }
  #declare bead_count = bead_count + 0.01;
#end  
