// Persistence of Vision Ray Tracer Scene Description File
// File: tmworsh.pov
// Vers: 3.1g.wmp.0.6a
// Desc: entry irtc worship round
// Date: dd/01/01
// Auth: Tom Melly, http://www.tomandlu.co.uk, tom@tomandlu.co.uk
//
#version unofficial MegaPov 0.6;

#include "colors.inc"
#include "finish.inc"
#include "metals.inc"
#include "glass.inc"
#include "furtex.pov"

#declare Debug = false;

  #declare level0=5;// for maketree
  #include "my_tree.inc"

  #include "arch.inc"
  #include "extras.inc"
  #include "couch.inc"

#if(!Debug)

                                                              
  #include "backfan.inc"
  #include "waist_fans.inc"
  #include "choker.inc"
  #include "necklace.inc"
  #include "rose.inc"
  #include "hat.inc"

//  #include "krishna.inc" // to use this, get d/l http://www.tomandlu.co.uk/pov/worsh_extras.zip

#end

camera{location  <0.0, 60.0, -175.0> look_at   <0.0, 60.0,  0.0>}

sky_sphere{pigment{bozo scale 1/10 pigment_map{[0.2 White][0.8 Blue]}}}

#declare MyPink = NeonPink/2; //rgb<1,0.5,0.5>/3;
#declare MyBlue = NeonBlue/4; //rgb<0.5,0.5,1>/3;
#declare MyYellow = rgb<1,0.95,0.75>/1;
light_source
{
  0*x                     // light's position (translated below)
  MyPink //color rgb <1,1/2,1/2>       // light's color
  spotlight               // this kind of light source
  translate <-500, 500, -1000> // <x y z> position of light
  point_at <0, 60, 0>      // direction of spotlight
  radius 3                // hotspot (inner, in degrees)
  tightness 25            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 4               // intensity falloff radius (outer, in degrees)
}

light_source
{
  0*x                     // light's position (translated below)
  MyPink*0.95 //color rgb <1,1/2,1/2>       // light's color
  spotlight               // this kind of light source
  translate <470, 510, -1100> // <x y z> position of light
  point_at <0, 65, 0>      // direction of spotlight
  radius 3.2                // hotspot (inner, in degrees)
  tightness 15            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 4               // intensity falloff radius (outer, in degrees)
}

light_source
{
  0*x                     // light's position (translated below)
  MyBlue*0.9 //color rgb <1,1/2,1/2>       // light's color
  spotlight               // this kind of light source
  translate <-490, 2, -1180> // <x y z> position of light
  point_at <1, 62, 0>      // direction of spotlight
  radius 3.1                // hotspot (inner, in degrees)
  tightness 15            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 4.1               // intensity falloff radius (outer, in degrees)
}

light_source
{
  0*x                     // light's position (translated below)
  MyBlue //color rgb <1,1/2,1/2>       // light's color
  spotlight               // this kind of light source
  translate <510, 2, -1250> // <x y z> position of light
  point_at <-2, 59, 0>      // direction of spotlight
  radius 3.1                // hotspot (inner, in degrees)
  tightness 10            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 3.9               // intensity falloff radius (outer, in degrees)
}

light_source
{
  0*x                     // light's position (translated below)
  MyYellow //color rgb <1,1/2,1/2>       // light's color
  spotlight               // this kind of light source
  translate <0, 1500, -1200> // <x y z> position of light
  point_at <3, 60, 0>      // direction of spotlight
  radius 2.1                // hotspot (inner, in degrees)
  tightness 23            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 3.1               // intensity falloff radius (outer, in degrees)
}

#declare Rand1 = seed(52432);
#declare back_image =
plane
{
  z, -1300
  texture{
    pigment{
      bozo scale <40,60,1>
      pigment_map{
        #declare n = 0;
        #while(n<=1)
          #declare GrayVal = ((rand(Rand1))*3)+1;
          [n rgb<(rand(Rand1)/GrayVal)+(GrayVal/4), (rand(Rand1)/GrayVal)+(GrayVal/4), (rand(Rand1)/GrayVal)+(GrayVal/4)>]
          #declare n = n + 0.05;
        #end
      }
    }
    finish {ambient 0.7}
  }
}

object{back_image}

#declare debug_arch_walls =
box{
  <-200,-250,1/2>,<200,200,5.01>
  pigment{Thistle*0.75}
  //normal{average normal_map{[agate 3 scale 7][granite 1][bozo 2 scale 5]}} finish{diffuse 0.8}//specular 1/2 roughness 0.005 reflection 0.2}
}

//object{debug_arch_walls}
